<!DOCTYPE html>
<html lang="zxx">

<head>
    <title>Refund Policy - RomaHost</title>
    <link rel="icon" href="images/icon.png" type="image/gif" sizes="16x16">
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Refund Policy - RomaHost" name="description">
    <meta content="" name="keywords">
    <meta content="" name="author">
    <!-- CSS Files
    ================================================== -->
    <link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" id="bootstrap">
    <link href="css/mdb.min.css" rel="stylesheet" type="text/css" id="mdb">
    <link href="css/plugins.css" rel="stylesheet" type="text/css">
    <link href="css/style.css" rel="stylesheet" type="text/css">
    <link href="css/coloring.css" rel="stylesheet" type="text/css">
    <link href="css/roma.css" rel="stylesheet" type="text/css">
</head>

<body>
    <div id="wrapper">

        <!-- page preloader begin -->
        <div id="de-loader"></div>
        <!-- page preloader close -->
        <!-- header begin -->
        <?php include 'include/header.php'; ?>
        <!-- header close -->
        <!-- content begin -->
        <div class="no-bottom no-top" id="content">
            <div id="top"></div>
            <section id="subheader" class="jarallax">
                <img src="images/background/2subheader2.jpg" class="jarallax-img" alt="">
                <div class="center-y relative text-center">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                <h1>Refund Policy</h1>
                            </div>
                            <div class="col-lg-6 offset-lg-3">
                                <p class="lead">Understand our guidelines and procedures regarding refunds.</p>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                </div>
            </section>

            <section id="section-hero" class="no-top mt-100" aria-label="section">

                <div class="dipeshc bg-white">
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Domains</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>Domains are a non-refundable product. If a free domain is registered with any hosting plan,
                                after the cancellation of the hosting plan, a partial refund will be issued (domain cost
                                will be deducted). We provide domains promptly, but if we are unable to deliver a domain
                                within 24 hours, we will issue a refund to the customer.</p>
                            <p>All domain prices listed are for standard domains, not premium domains. Currently, we do not
                                have a specific tool to check for premium domains as we are in our beta stage. If the domain
                                you selected is identified as a premium domain, we will be happy to provide a refund or
                                credit to your account, depending on your preference.</p>
                            <p>If you host any phishing or abusive content, the domain will be suspended by the registrar.
                                We are not responsible for such suspensions, and as per our terms, domains are
                                non-refundable.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Hosting</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>At our company, we take great pride in providing excellent customer service. We guarantee
                                that any issue you experience will be resolved within 72 hours on working days from Monday
                                to Friday. If we are unable to resolve your issue within that timeframe, we will happily
                                issue a refund.</p>
                            <p>RomaHost provides a refund guarantee ranging from 7 days to 90 days, depending on the plan
                                and billing cycle. The specific duration of the refund guarantee is transparently mentioned
                                for each plan.</p>
                            <p>To be eligible for a refund under our money-back guarantee, customers must meet the following
                                requirements:</p>
                            <ul>
                                <li>You must not have been a customer of RomaHost in the past.</li>
                                <li>No abuse or misuse should have occurred on your service (refer to Account Security and
                                    RomaHost systems, CPU, Bandwidth, and Disk Usage policies).</li>
                                <li>You must not have initiated a dispute or chargeback.</li>
                                <li>The money-back guarantee applies to the base of the billing cycle as specified for each
                                    plan.</li>
                                <li>Gateway charges are non-refundable.</li>
                                <li>If you purchased a plan for 3 months to 3 years, the amount for the period used will be
                                    deducted from the refund.</li>
                                <li>If you claimed a free domain with our hosting, the domain amount will also be deducted
                                    from the refund.</li>
                            </ul>
                            <p>Any violations of these terms will void your right to a refund.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>VPS & Dedicated Server</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>We do not provide any Refund IN VPS & Dedicated Server, so please proceed with your purchase
                                at your own risk. Additionally, server licenses are non-refundable.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Service Cancellation</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>If we cancel the service, a refund will be automatically provided if our internal policy
                                allows for it. However, if any of our terms and conditions are breached, including instances
                                of abuse, a refund will not be provided.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Payment With Crypto</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>RomaHost allows users to buy and sell various digital services using cryptocurrency
                                payments. It is important to note that these transactions are typically non-refundable.</p>
                        </div>
                    </div>
                    <strong>
                        <font color="#fc0000">Last Update On 7<sup>th</sup>-July-2024 </font>
                    </strong>
                </div>
            </section>
            <!-- content close -->
            <a href="#" id="back-to-top"></a>
            <!-- footer begin -->
            <?php include 'include/footer.php'; ?>
            <!-- footer close -->
        </div>

        <!-- Javascript Files
    ================================================== -->
        <script src="js/plugins.js"></script>
        <script src="js/designesia.js"></script>
        <script>
            jQuery(document).ready(function() {
                $(function() {
                    // jquery typed plugin
                    $(".typed").typed({
                        stringsElement: $('.typed-strings'),
                        typeSpeed: 100,
                        backDelay: 500,
                        loop: true,
                        contentType: 'html', // or text
                        // defaults to false for infinite loop
                        loopCount: false,
                        callback: function() {
                            null;
                        },
                        resetCallback: function() {
                            newTyped();
                        }
                    });
                });
            });
        </script>
</body>

</html>