<!DOCTYPE html>
<html lang="zxx">

<head>
    <title>Unlimited Policy - RomaHost</title>
    <link rel="icon" href="images/icon.png" type="image/gif" sizes="16x16">
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Unlimited Policy - RomaHost" name="description">
    <meta content="" name="keywords">
    <meta content="" name="author">
    <!-- CSS Files
    ================================================== -->
    <link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" id="bootstrap">
    <link href="css/mdb.min.css" rel="stylesheet" type="text/css" id="mdb">
    <link href="css/plugins.css" rel="stylesheet" type="text/css">
    <link href="css/style.css" rel="stylesheet" type="text/css">
    <link href="css/coloring.css" rel="stylesheet" type="text/css">
    <link href="css/roma.css" rel="stylesheet" type="text/css">
</head>

<body>
    <div id="wrapper">

        <!-- page preloader begin -->
        <div id="de-loader"></div>
        <!-- page preloader close -->
        <!-- header begin -->
        <?php include 'include/header.php'; ?>
        <!-- header close -->
        <!-- content begin -->
        <div class="no-bottom no-top" id="content">
            <div id="top"></div>
            <section id="subheader" class="jarallax">
                <img src="images/background/2subheader2.jpg" class="jarallax-img" alt="">
                <div class="center-y relative text-center">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                <h1>Unlimited/Unmetered Policy</h1>
                            </div>
                            <div class="col-lg-6 offset-lg-3">
                                <p class="lead">Learn about our commitment to providing unlimited resources without usage restrictions.</p>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                </div>
            </section>

            <section id="section-hero" class="no-top mt-100" aria-label="section">

                <div class="dipeshc bg-white">
                    <p>The Unlimited/Unmetered Policy is an agreement between RomaHost and you. This policy sets forth the
                        terms and conditions for the use of any products and services provided by RomaHost that are
                        advertised as "unlimited" or "unmetered." Please read carefully to ensure you understand our terms
                        before purchasing any of our products or services.</p>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Shared Hosting Limitations</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>For Shared Hosting (Shared, Cloud, WordPress), the following limitations apply:</p>
                            <ul>
                                <li>Maximum cPanel storage limit is 50GB, including SQL databases and email accounts.</li>
                                <li>We do not allow the use of storage for backups, movie download sites, software download
                                    sites, or any file storage such as movies, zip files, and backups. Our unlimited hosting
                                    is strictly for hosting website files such as HTML, PHP, or other related site files.
                                </li>
                                <li>Storage limit may not apply if you are on our highest plan, but it is still not for
                                    unlimited online storage, videos, images, audio, games, installers, backups, or
                                    archiving.</li>
                            </ul>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Reseller Hosting Limitations</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>For Reseller Hosting, the following limitations apply:</p>
                            <ul>
                                <li>Maximum per cPanel account is 50GB, including SQL databases and email accounts.</li>
                                <li>We do not allow the use of storage for backups, movie download sites, software download
                                    sites, or any file storage such as movies, zip files, and backups. Our unlimited hosting
                                    is strictly for hosting website files such as HTML, PHP, or other related site files.
                                </li>
                                <li>If any account abuses CPU usage or engages in DDoS attacks, we reserve the right to
                                    suspend or terminate the account. We provide a backup before termination. If any user
                                    exceeds usage limits, we send 3 warnings with a 48-hour resolution time. If unresolved,
                                    the account is suspended with an additional 24 hours to resolve the issue before
                                    termination, at which point no backup will be provided.</li>
                            </ul>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Bandwidth Usage</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>We do not set any bandwidth limits on any account. However, if users engage in illegal
                                activities such as downloading files, using the account as a browser proxy, or any other
                                inappropriate use of bandwidth, we will suspend the account. Reactivation fees are $3 for
                                the first suspension, $8 for the second, and termination on the third violation.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main" id="cpu">
                        <div class="dipesh1-head text-center">
                            <h2>CPU, RAM, IO, EP Usage</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>Different plans have different resource limits. If your website exceeds these limits more
                                than 5 times in one day, it is mandatory to upgrade your account. Failure to upgrade will
                                result in the cancellation of your subscription, with a refund provided after deducting the
                                usage days amount.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>SQL Database</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>Accounts with excessive database sizes (over 1 GB) may negatively affect server performance.
                                We may request that database sizes be reduced to ensure proper performance or disable the
                                account. Multiple databases can be created, but each should not exceed 1 GB.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Email Account</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>Each email account is limited to a maximum storage size of 5GB. Accounts exceeding this limit
                                may negatively impact server performance. We may request that email storage be reduced to
                                ensure proper performance or disable the account if the limit is exceeded.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Reseller Unlimited Account</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>In the SparkShift.Host Reseller Unlimited plan, you can create up to 800 cPanel accounts. If
                                you exceed 800+ cPanel accounts, additional charges will apply.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Unlimited File Transfer</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>RomaHost does not set any limits on the amount of visitor traffic a website can receive or
                                on the amount of content a hosting subscriber can upload to their website in a given month.
                                There are no additional fees for increased bandwidth usage, as long as the use complies with
                                these terms. However, RomaHost reserves the right to limit processor time, bandwidth,
                                processes, or memory to prevent negative impacts on other hosting subscribers.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>What "Unlimited" means</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>Unlimited Disk Space/Bandwidth/Website Plans means that we do not set a limit on the amount
                                of bandwidth, websites, or disk space you may use for the normal operation of a personal or
                                small business website, provided it complies with this agreement. If your service usage or
                                content poses a risk to the stability, performance, or uptime of our servers or other
                                infrastructure, you may be required to upgrade to a VPS, or we may take action to restrict
                                your resource usage.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>What "Unlimited" DOES NOT mean</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>RomaHost employs mechanisms to protect its hosting subscribers and systems from abuse. Our
                                "Unlimited" hosting is not intended for single or few hosting subscribers to unfairly impact
                                the experience of other subscribers. Our service is designed for small and medium-sized
                                businesses, not for large enterprises or non-typical applications better suited to a VPS or
                                dedicated server. We place automated safeguards to prevent any website from adversely
                                impacting the system until we can evaluate the resource needs.</p>
                        </div>
                    </div>
                    <strong>
                        <font color="#fc0000">Last Update On 7<sup>th</sup>-July-2024 </font>
                    </strong>
                </div>
            </section>
            <!-- content close -->
            <a href="#" id="back-to-top"></a>
            <!-- footer begin -->
            <?php include 'include/footer.php'; ?>
            <!-- footer close -->
        </div>

        <!-- Javascript Files
    ================================================== -->
        <script src="js/plugins.js"></script>
        <script src="js/designesia.js"></script>
        <script>
            jQuery(document).ready(function() {
                $(function() {
                    // jquery typed plugin
                    $(".typed").typed({
                        stringsElement: $('.typed-strings'),
                        typeSpeed: 100,
                        backDelay: 500,
                        loop: true,
                        contentType: 'html', // or text
                        // defaults to false for infinite loop
                        loopCount: false,
                        callback: function() {
                            null;
                        },
                        resetCallback: function() {
                            newTyped();
                        }
                    });
                });
            });
        </script>
</body>

</html>