<!DOCTYPE html>
<html lang="zxx">

<head>
    <title>Hospedagem Wordpress - Roma Host</title>
    <link rel="icon" href="images/icon.png" type="image/gif" sizes="16x16">
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Hospedagem Wordpress - Roma Host" name="description">
    <meta content="" name="keywords">
    <meta content="" name="author">
    <!-- CSS Files
    ================================================== -->
    <link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" id="bootstrap">
    <link href="css/mdb.min.css" rel="stylesheet" type="text/css" id="mdb">
    <link href="css/plugins.css" rel="stylesheet" type="text/css">
    <link href="css/style.css" rel="stylesheet" type="text/css">
    <link href="css/coloring.css" rel="stylesheet" type="text/css">
</head>

<body>
    <div id="wrapper">

        <!-- page preloader begin -->
        <div id="de-loader"></div>
        <!-- page preloader close -->
        <!-- header begin -->
        <?php include 'include/header.php'; ?>
        <!-- header close -->
        <!-- content begin -->
        <div class="no-bottom no-top" id="content">
            <div id="top"></div>

            <section id="subheader" class="jarallax">
                <img src="images/background/2subheader2.jpg" class="jarallax-img" alt="">
                <div class="center-y relative text-center">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                <h1>Hospedagem Wordpress</h1>
                            </div>
                            <div class="col-lg-6 offset-lg-3">
                                <p class="lead">Hospedagem otimizada para sites WordPress.</p>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                </div>
            </section>

            <section id="section-hero" class="no-top mt-100" aria-label="section">
                <div class="container">

                    <div class="spacer-10"></div>
                    <div class="row g-custom-x">
                        <div class="col-lg-4 col-md-6 col-sm-12 mb-sm-30">
                            <div class="pricing-table pricing-s1">
                                <div class="top">
                                    <h3>WP Básico</h3>
                                </div>
                                <div class="mid">
                                    <p class="price">
                                        <span class="currency">R$</span>
                                        <span class="m opt-1">24,00</span>
                                        <span class="period">/ Mensal</span>
                                    </p>
                                </div>
                                <div class="bottom">
                                    <ul>
                                        <li><i class="fa fa-check"></i><strong>1</strong> Website</li>
                                        <li><i class="fa fa-check"></i><strong>10 GB</strong> Espaço Disco</li>
                                        <li><i class="fa fa-check"></i><strong>Ilimitada </strong> Transferência</li>
                                        <li><i class="fa fa-check"></i><strong>Ilimitado</strong> MySql Database</li>
                                        <li><i class="fa fa-check"></i><strong>cPanel</strong> +
                                            <strong>Softaculous</strong>
                                        </li>
                                        <li><i class="fa fa-check"></i><strong>Diário</strong> Backups </li>
                                        <li><i class="fa fa-check"></i><strong>Grátis</strong> Certificado SSL</li>
                                        </li>
                                    </ul>
                                </div>
                                <div class="action">
                                    <a href="#PRODUCTLINK" class="btn-main">Assinar Plano</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-12 mb-sm-30">
                            <div class="pricing-table pricing-s1 table-featured">
                                <div class="top">
                                    <h3>WP Plus</h3>
                                </div>
                                <div class="mid">
                                    <p class="price">
                                        <span class="currency">R$</span>
                                        <span class="m opt-1">33,00</span>
                                        <span class="period">/ Mensal</span>
                                    </p>
                                </div>
                                <div class="bottom">
                                    <ul>
                                        <li><i class="fa fa-check"></i><strong>10</strong> Website</li>
                                        <li><i class="fa fa-check"></i><strong>30 GB</strong> Espaço Disco</li>
                                        <li><i class="fa fa-check"></i><strong>Ilimitada </strong> Transferência</li>
                                        <li><i class="fa fa-check"></i><strong>Ilimitado</strong> MySql Database</li>
                                        <li><i class="fa fa-check"></i><strong>cPanel</strong> +
                                            <strong>Softaculous</strong>
                                        </li>
                                        <li><i class="fa fa-check"></i><strong>Diário</strong> Backups </li>
                                        <li><i class="fa fa-check"></i><strong>Grátis</strong> Certificado SSL</li>
                                    </ul>
                                </div>
                                <div class="action">
                                    <a href="#PRODUCTLINK" class="btn-main">Assinar Plano</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-12 mb-sm-30">
                            <div class="pricing-table pricing-s1">
                                <div class="top">
                                    <h3>WP Pro</h3>
                                </div>
                                <div class="mid">
                                    <p class="price">
                                        <span class="currency">R$</span>
                                        <span class="m opt-1">45,00</span>
                                        <span class="period">/ Mensal</span>
                                    </p>
                                </div>
                                <div class="bottom">
                                    <ul>
                                        <li><i class="fa fa-check"></i><strong>Ilimitado</strong> Websites</li>
                                        <li><i class="fa fa-check"></i><strong>Ilimitado</strong> Espaço Disco</li>
                                        <li><i class="fa fa-check"></i><strong>Ilimitada </strong> Transferência</li>
                                        <li><i class="fa fa-check"></i><strong>Ilimitado</strong> MySql Database</li>
                                        <li><i class="fa fa-check"></i><strong>cPanel</strong> +
                                            <strong>Softaculous</strong>
                                        </li>
                                        <li><i class="fa fa-check"></i><strong>Diário</strong> Backups </li>
                                        <li><i class="fa fa-check"></i><strong>Grátis</strong> Certificado SSL</li>
                                    </ul>
                                </div>
                                <div class="action">
                                    <a href="#PRODUCTLINK" class="btn-main">Assinar Plano</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <p class="text-danger text-center"><strong>*Valores em R$ (BRL)</strong></p>
            </section>

            <section id="section-steps" class="no-top">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 offset-lg-3 text-center">
                            <h5 class="s2">Etapas fáceis</h5>
                            <h2>Recursos que trazem potência máxima ao seu site.</h2>
                            <div class="spacer-20"></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <i class="icon-alarmclock de-icon mb20"></i>
                            <h4>Ativação Imediata</h4>
                            <p>A ativação instantânea de hospedagem permite uma configuração rápida de hospedagem na web sem qualquer demora. Usuários
                                podem começar imediatamente a enviar arquivos do site e colocá-los no ar na
                                Internet. Este recurso conveniente economiza tempo em comparação com configurações de hospedagem tradicionais.</p>
                        </div>
                        <div class="col-md-3">
                            <i class="icon-refresh de-icon mb20"></i>
                            <h4>99.99% Uptime</h4>
                            <p>99.99% uptime significa que um servidor está operacional 99,99% do tempo com no máximo 2 tempos de inatividade
                                de tempo de inatividade por mês. Isto é importante para que os websites garantam acessibilidade e
                                melhorar a experiência do usuário.</p>
                        </div>
                        <div class="col-md-3">
                            <i class="icon-layers de-icon mb20"></i>
                            <h4>LiteSpeed Web Server</h4>
                            <p>LiteSpeed Web Server é um software de servidor web de alto desempenho projetado para sites com
                                alto tráfego e aplicações exigentes. Oferece maior velocidade, segurança e
                                confiabilidade em comparação com servidores web tradicionais, como Apache. </p>
                        </div>
                        <div class="col-md-3">
                            <i class="icon-cloud de-icon mb20"></i>
                            <h4>Backup diário Database</h4>
                            <p>Backups diários de banco de dados referem-se à criação e salvamento regular de uma cópia de um banco de dados. Esse
                                é feito para proteger os dados em caso de falha do sistema, erro humano ou ataques maliciosos.
                            </p>
                        </div>
                    </div>
                </div>
            </section>

            <section id="section-faq">
                <div class="container">
                    <div class="row">
                        <div class="col text-center">
                            <h5 class="s2">Você tem</h5>
                            <h2>Alguma pergunta?</h2>
                            <div class="spacer-20"></div>
                        </div>
                    </div>
                    <div class="row g-custom-x">
                        <div class="col-md-6 wow fadeInUp">
                            <div class="accordion secondary">
                                <div class="accordion-section">
                                    <div class="accordion-section-title" data-tab="#accordion-1">
                                        Como posso começar com a minha hospedagem de sites?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-1">
                                        <p>Para começar com a sua hospedagem de sites, você precisará escolher um
                                            provedor e adquirir um plano de hospedagem. Depois de escolher a Roma Host
                                            e plano, você precisará registrar um nome de domínio (se ainda não tiver)
                                            e configurar sua conta com a Roma Host. Depois disso, você poderá fazer upload
                                            dos arquivos do seu site para o servidor e disponibilizá-los na Internet utilizando
                                            a Roma Host. Também é muito importante manter sua hospedagem atualizada
                                            e mantido, bem como proteger seu site para garantir que ele funcione sem problemas
                                            e estar protegido contra quaisquer ameaças potenciais à segurança.</p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-2">
                                        Qual é a diferença para cada plano?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-2">
                                        <p>A diferença entre os planos de hospedagem de sites pode variar, mas geralmente os planos
                                            diferem em termos de quantidade de espaço de armazenamento, largura de banda e recursos
                                            oferecidos. Espaço de armazenamento refere-se à quantidade de espaço em disco disponível
                                            para armazenar os arquivos e a largura de banda do seu site é a quantidade de dados que
                                            pode ser transferidos de e para o seu site todos os meses. Algumas outras características
                                            comuns que podem variar entre os planos incluem: o número de sites, contas de e-mail,
                                            Certificados SSL, painel de controle e opções de backup. É importante avaliar
                                            as necessidades específicas do seu site e compare-as com os recursos oferecidos
                                            por diferentes planos antes de tomar uma decisão.</p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-3">
                                        Qual plano de hospedagem de sites eu preciso?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-3">
                                        <p>O tipo de hospedagem de sites que você precisa depende das necessidades específicas do seu
                                            local na rede Internet. Aqui estão algumas opções:
                                            <li>Hospedagem compartilhada: adequada para sites de pequeno e médio porte com baixa a
                                                tráfego moderado.</li>
                                            <li>Hospedagem VPS: Adequado para sites de médio porte com desempenho moderado a alto
                                                tráfego.</li>
                                            <li>Hospedagem dedicada: adequada para grandes sites com alto tráfego.</li>
                                            <li>Hospedagem em nuvem: adequada para sites que apresentam tráfego flutuante
                                                e precisa de escalabilidade.</li>
                                            </ul><br>
                                            É importante considerar o tráfego, a segurança e o desempenho do seu site.
                                            e requisitos de escalabilidade antes de escolher um serviço de hospedagem de sites.
                                        </p>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 wow fadeInUp">
                            <div class="accordion secondary">
                                <div class="accordion-section">
                                    <div class="accordion-section-title" data-tab="#accordion-b-4">
                                        Por que preciso de um nome de domínio?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-b-4">
                                        <p>
                                        <ol>
                                            <li>Branding: um nome de domínio ajuda a estabelecer sua marca e criar uma
                                                imagem memorável e profissional para o seu negócio.</li>
                                            <li>Identidade: um nome de domínio dá ao seu site uma identidade única e o define
                                                além dos milhões de outros sites na internet.</li>
                                            <li>Otimização de mecanismos de pesquisa: um nome de domínio que seja relevante para a sua
                                                empresa pode melhorar a classificação do seu mecanismo de pesquisa e tornar mais fácil para
                                                que os clientes encontrem seu site.</li>
                                            <li>Endereço de e-mail: você pode usar seu nome de domínio para criar
                                                endereços de e-mail com aparência profissional, como contato@romahost.com.br.
                                            </li>
                                            <li>Credibilidade: Ter um nome de domínio pode adicionar credibilidade ao seu negócio,
                                                tornando mais provável que os clientes confiem em seu site e façam
                                                negócio com você.</li>
                                        </ol>
                                        </p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-b-5">
                                        Como proteger o meu site contra hackers?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-b-5">
                                        <p>
                                        <ol>
                                            <li>Mantenha o software e os plug-ins do seu site atualizados.</li>
                                            <li>Use uma senha forte e altere-a regularmente.</li>
                                            <li>Use um host confiável com medidas de segurança em vigor.</li>
                                            <li>Use um firewall de aplicativo web (WAF) para se proteger contra ataques comuns.
                                            </li>
                                            <li>Faça backup regularmente do seu site e armazene-o em um local seguro.</li>
                                            <li>Use autenticação de dois fatores para login.</li>
                                            <li>Monitore regularmente seu site em busca de qualquer atividade suspeita.</li>
                                            <li>Use HTTPS para criptografar a comunicação entre o navegador e o servidor.
                                            </li>
                                        </ol>
                                        </p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-b-6">
                                        Como faço o backup do meu site?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-b-6">
                                        <p>
                                        <ol>
                                            <li>Faça login na sua conta cPanel.</li>
                                            <li>Role para baixo até a seção "Arquivos" e clique no ícone "Backup".</li>
                                            <li>Na seção "Backup completo", clique em "Baixar um site completo
                                                Botão Backup".</li>
                                            <li>Selecione o destino do arquivo de backup (por exemplo, diretório inicial ou
                                                servidor FTP remoto) e clique no botão "Gerar Backup".</li>
                                            <li>Assim que o backup for concluído, você poderá fazer o download do backup
                                                arquivo para o seu computador local.</li>
                                        </ol>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <section id="section-banner" class="no-bottom no-top" data-bgcolor="#DBEDF7">
                <div class="container">
                    <div class="row align-items-center g-custom-x">
                        <div class="col-lg-4 d-none d-lg-block d-xl-block  text-center">
                            <img class="relative img-fluid mt-60" src="images/misc/1.png" alt="">
                        </div>

                        <div class="col-lg-4 col-md-6">
                            <div class="p-sm-30 pb-sm-0 mb-sm-0">
                                <h2><span class="color-gradient">30 dias</span> de garantia fornecido</h2>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6">
                            <div class="p-sm-30">
                                <div class="spacer-20 sm-hide"></div>
                                <p class="lead">Se você não estiver satisfeito, reembolsaremos seu pagamento. Sem complicações, sem riscos. Você
                                    pode cancelar o plano a qualquer momento.</p>
                                <div class="spacer-half"></div>
                                <a class="btn-main" href="Hospedagem-WordPress">Escolher Plano</a>
                                <p class="d-small mt20">*O cancelamento deve ser no prazo máximo de 30 dias corridos.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>

        <!-- content close -->
        <a href="#" id="back-to-top"></a>
        <!-- footer begin -->
        <?php include 'include/footer.php'; ?>
        <!-- footer close -->
    </div>

    <!-- Javascript Files
    ================================================== -->
    <script src="js/plugins.js"></script>
    <script src="js/designesia.js"></script>
    <script>
        jQuery(document).ready(function() {
            $(function() {
                // jquery typed plugin
                $(".typed").typed({
                    stringsElement: $('.typed-strings'),
                    typeSpeed: 100,
                    backDelay: 500,
                    loop: true,
                    contentType: 'html', // or text
                    // defaults to false for infinite loop
                    loopCount: false,
                    callback: function() {
                        null;
                    },
                    resetCallback: function() {
                        newTyped();
                    }
                });
            });
        });
    </script>
</body>

</html>