<!DOCTYPE html>
<html lang="zxx">

<head>
    <title>Política Ilimitada - Roma Host</title>
    <link rel="icon" href="images/icon.png" type="image/gif" sizes="16x16">
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Política Ilimitada - Roma Host" name="description">
    <meta content="" name="keywords">
    <meta content="" name="author">
    <!-- CSS Files
    ================================================== -->
    <link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" id="bootstrap">
    <link href="css/mdb.min.css" rel="stylesheet" type="text/css" id="mdb">
    <link href="css/plugins.css" rel="stylesheet" type="text/css">
    <link href="css/style.css" rel="stylesheet" type="text/css">
    <link href="css/coloring.css" rel="stylesheet" type="text/css">
    <link href="css/roma.css" rel="stylesheet" type="text/css">
</head>

<body>
    <div id="wrapper">

        <!-- page preloader begin -->
        <div id="de-loader"></div>
        <!-- page preloader close -->
        <!-- header begin -->
        <?php include 'include/header.php'; ?>
        <!-- header close -->
        <!-- content begin -->
        <div class="no-bottom no-top" id="content">
            <div id="top"></div>
            <section id="subheader" class="jarallax">
                <img src="images/background/2subheader2.jpg" class="jarallax-img" alt="">
                <div class="center-y relative text-center">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                <h1>Política Ilimitada</h1>
                            </div>
                            <div class="col-lg-6 offset-lg-3">
                                <p class="lead">Saiba mais sobre nosso compromisso em fornecer recursos ilimitados sem restrições de uso.</p>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                </div>
            </section>

            <section id="section-hero" class="no-top mt-100" aria-label="section">

                <div class="dipeshc bg-white">
                    <p>A Política Ilimitada é um acordo entre a Roma Host e você. Esta política estabelece os termos e condições para o uso de quaisquer produtos e serviços fornecidos pela Roma Host que sejam anunciados como “ilimitados”. Por favor, leia atentamente para garantir que você entende nossos termos antes de comprar qualquer um de nossos produtos ou serviços.</p>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Limitações de hospedagem compartilhada</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>Para Hospedagem Compartilhada (Compartilhada, Nuvem, WordPress), aplicam-se as seguintes limitações:</p>
                            <ul>
                                <li>O limite máximo de armazenamento do cPanel é de 50 GB, incluindo bancos de dados SQL e contas de e-mail.</li>
                                <li>Não permitimos o uso de armazenamento para backups, sites de download de filmes, sites de download de software ou qualquer armazenamento de arquivo, como filmes, arquivos zip e backups. Nossa hospedagem ilimitada é estritamente para hospedar arquivos de sites, como HTML, PHP ou outros arquivos de sites relacionados.
                                </li>
                                <li>O limite de armazenamento pode não se aplicar se você estiver em nosso plano mais alto, mas ainda não se aplica a armazenamento on-line ilimitado, vídeos, imagens, áudio, jogos, instaladores, backups ou arquivamento.</li>
                            </ul>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Limitações de hospedagem de revenda</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>Para hospedagem de revenda, as seguintes limitações se aplicam:</p>
                            <ul>
                                <li>O máximo por conta cPanel é de 50 GB, incluindo bancos de dados SQL e contas de e-mail.</li>
                                <li>Não permitimos o uso de armazenamento para backups, sites de download de filmes, sites de download de software ou qualquer armazenamento de arquivo, como filmes, arquivos zip e backups. Nossa hospedagem ilimitada é estritamente para hospedar arquivos de sites, como HTML, PHP ou outros arquivos de sites relacionados.
                                </li>
                                <li>Se qualquer conta abusar do uso da CPU ou se envolver em ataques DDoS, reservamo-nos o direito de suspender ou encerrar a conta. Fornecemos um backup antes do encerramento. Se qualquer usuário exceder os limites de uso, enviamos 3 avisos com um tempo de resolução de 48 horas. Se não for resolvido, a conta será suspensa com mais 24 horas para resolver o problema antes do encerramento, momento em que nenhum backup será fornecido.</li>
                            </ul>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Uso de largura de banda</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>Não definimos limites de largura de banda em nenhuma conta. No entanto, se os usuários se envolverem em atividades ilegais, como baixar arquivos, usar a conta como proxy do navegador ou qualquer outro uso inapropriado de largura de banda, suspenderemos a conta. As taxas de reativação são de R$ 250,00 para a primeira suspensão, R$ 200,00 para a segunda e desligamento na terceira violação.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main" id="cpu">
                        <div class="dipesh1-head text-center">
                            <h2>Uso de CPU, RAM, IO, EP</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>Planos diferentes têm limites de recursos diferentes. Se o seu site ultrapassar esses limites mais de 5 vezes em um dia, é obrigatório atualizar sua conta. A não atualização resultará no cancelamento da sua assinatura, com reembolso fornecido após dedução do valor dos dias de uso.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Banco de dados SQL</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>Contas com tamanhos excessivos de banco de dados (acima de 1 GB) podem afetar negativamente o desempenho do servidor. Poderemos solicitar que o tamanho dos bancos de dados seja reduzido para garantir o desempenho adequado ou desabilitar a conta. Vários bancos de dados podem ser criados, mas cada um não deve exceder 1 GB.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Conta de e-mail</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>Cada conta de e-mail é limitada a um tamanho máximo de armazenamento de 5 GB. Contas que excedem esse limite podem impactar negativamente o desempenho do servidor. Podemos solicitar que o armazenamento de e-mail seja reduzido para garantir o desempenho adequado ou desabilitar a conta se o limite for excedido.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Conta de revendedor ilimitada</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>No plano Roma Host Revenda Ilimitada, você pode criar até 800 contas cPanel. Se você exceder mais de 800 contas cPanel, serão aplicadas taxas adicionais.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>Transferência ilimitada de arquivos</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>A Roma Host não define nenhum limite para a quantidade de tráfego de visitantes que um site pode receber ou para a quantidade de conteúdo que um assinante de hospedagem pode enviar para seu site em um determinado mês. Não há taxas adicionais para uso de largura de banda maior, desde que o uso esteja em conformidade com estes termos. No entanto, a Roma Host reserva-se o direito de limitar o tempo do processador, largura de banda, processos ou memória para evitar impactos negativos em outros assinantes de hospedagem.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>O que significa "Ilimitado"</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>Planos de Espaço em Disco/Largura de Banda/Site Ilimitados significa que não definimos um limite na quantidade de largura de banda, sites ou espaço em disco que você pode usar para a operação normal de um site pessoal ou de pequena empresa, desde que esteja em conformidade com este acordo. Se o uso do seu serviço ou conteúdo representar um risco à estabilidade, desempenho ou tempo de atividade de nossos servidores ou outra infraestrutura, você pode ser obrigado a atualizar para um VPS, ou podemos tomar medidas para restringir o uso do seu recurso.</p>
                        </div>
                    </div>
                    <div class="dipesh1-main">
                        <div class="dipesh1-head text-center">
                            <h2>O que "Ilimitado" não significa</h2>
                        </div>
                        <div class="dipesh1-content">
                            <p>A Roma Host emprega mecanismos para proteger seus assinantes e sistemas de hospedagem contra abusos. Nossa hospedagem "Ilimitada" não se destina a assinantes de hospedagem únicos ou poucos para impactar injustamente a experiência de outros assinantes. Nosso serviço é projetado para pequenas e médias empresas, não para grandes empresas ou aplicativos não típicos mais adequados para um VPS ou servidor dedicado. Colocamos salvaguardas automatizadas para evitar que qualquer site tenha impacto adverso no sistema até que possamos avaliar as necessidades de recursos.</p>
                        </div>
                    </div>
                    <strong>
                        <font color="#fc0000">Última atualização em 27<sup></sup>de Agosto de 2024 </font>
                    </strong>
                </div>
            </section>
            <!-- content close -->
            <a href="#" id="back-to-top"></a>
            <!-- footer begin -->
            <?php include 'include/footer.php'; ?>
            <!-- footer close -->
        </div>

        <!-- Javascript Files
    ================================================== -->
        <script src="js/plugins.js"></script>
        <script src="js/designesia.js"></script>
        <script>
            jQuery(document).ready(function() {
                $(function() {
                    // jquery typed plugin
                    $(".typed").typed({
                        stringsElement: $('.typed-strings'),
                        typeSpeed: 100,
                        backDelay: 500,
                        loop: true,
                        contentType: 'html', // or text
                        // defaults to false for infinite loop
                        loopCount: false,
                        callback: function() {
                            null;
                        },
                        resetCallback: function() {
                            newTyped();
                        }
                    });
                });
            });
        </script>
</body>

</html>