<!DOCTYPE html>
<html lang="zxx">

<head>
    <title>Roma Host - Hospedagem de Sites</title>
    <link rel="icon" href="images/icon.png" type="image/gif" sizes="16x16">
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Roma Host - Hospedagem de Sites" name="description">
    <meta content="" name="keywords">
    <meta content="" name="author">
    <!-- CSS Files
    ================================================== -->
    <link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" id="bootstrap">
    <link href="css/mdb.min.css" rel="stylesheet" type="text/css" id="mdb">
    <link href="css/plugins.css" rel="stylesheet" type="text/css">
    <link href="css/style.css" rel="stylesheet" type="text/css">
    <link href="css/coloring.css" rel="stylesheet" type="text/css">
</head>

<body>
    <div id="wrapper">

        <!-- page preloader begin -->
        <div id="de-loader"></div>
        <!-- page preloader close -->
        <!-- header begin -->
        <?php include 'include/header.php'; ?>
        <!-- header close -->
        <!-- content begin -->
        <div class="no-bottom no-top" id="content">
            <div id="top"></div>
            <section id="section-hero" class="v-center" aria-label="section" data-bgimage='url(images/background/3.jpg)'>
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-10 offset-lg-1 text-center">
                            <div class="spacer-single"></div>
                            <h1 class="very-big wow fadeInUp">Aqui você encontra <span class="id-color">Inovação</span> e <span class="id-color">Tecnologia</span> para o seu
                                <span class="clearfix d-lg-none d-block"></span>
                                <span class="typed-strings">
                                    <p>negócio.</p>
                                    <p>portfolio.</p>
                                    <p>ecommerce.</p>
                                </span>
                                <span class="typed"></span>
                            </h1>
                        </div>
                        <div class="col-lg-6 offset-lg-3 text-center">
                            <p class="wow fadeInUp" data-wow-delay=".2s">Hospedagem segura de alto desempenho para seu site. Não perca mais clientes pela lentidão do seu serviço de hospedagem. Obtenha aqui o plano ideal para a sua necessidade!</p>
                        </div>
                        <div class="col-lg-8 offset-lg-2 text-center">
                            <form action='https://romahost.com.br/domainchecker.php' class="row wow fadeInUp" data-wow-delay=".4s" id='form_sb' method="post" name="form_sb">
                                <div class="col">
                                    <div class="spacer-10"></div>
                                    <input class="form-control" id='domain_name' name='domain' placeholder="buscar domínios" type='text'> <a id="btn-submit" href="javascript:;" onclick="document.getElementById('form_sb').submit();"><i class="arrow_right"></i></a>
                                    <div class="clearfix"></div>
                                    <div class="spacer-10"></div>
                                    <div class="domain-ext pos-left">
                                        <div class="ext wow flipInY" data-wow-delay="1.1s">
                                            <h4 class="id-color">.com</h4>
                                            R$60,00/no 1º ano
                                        </div>
                                        <div class="ext wow flipInY" data-wow-delay="1.2s">
                                            <h4 class="id-color">.website</h4>
                                            R$30,00/no 1º ano
                                        </div>
                                        <div class="ext wow flipInY" data-wow-delay="1.3s">
                                            <h4 class="id-color">.site</h4>
                                            R$30,00/no 1º ano
                                        </div>
                                        <div class="ext wow flipInY" data-wow-delay="1.4s">
                                            <h4 class="id-color">.shop</h4>
                                            R$30,00/no 1º ano
                                        </div>
                                        <div class="ext wow flipInY" data-wow-delay="1.5s">
                                            <h4 class="id-color">.store</h4>
                                            R$30,00/no 1º ano
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>

                    </div>
                </div>
            </section>

            <section class="no-top">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 wow fadeInUp">
                            <img class="img-fluid anim-up-down" src="images/misc/server.png" alt="">
                        </div>
                        <div class="col-lg-6 wow fadeInUp" data-wow-delay=".3s">
                            <div class="p-sm-30 pb-sm-0 mb-sm-0">
                                <h2>A nova funcionalidade traz o máximo <span class="color-gradient">poder</span> para o seu
                                    site.</h2>
                                <p>Na Roma Host, orgulhamo-nos de ser o destino final para experiências imbatíveis
                                    serviços de hospedagem na web e suporte qualificados, todos incluídos com recursos ilimitados
                                    para o seu negócio.</p>
                                <div class="row">
                                    <div class="col-md-5">
                                        <ul class="ul-style-2">
                                            <li>
                                                <h4>Ativação Imediata</h4>
                                            </li>
                                            <li>
                                                <h4>99.9% Uptime</h4>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-md-5">
                                        <ul class="ul-style-2">
                                            <li>
                                                <h4>Servidores Robustos</h4>
                                            </li>
                                            <li>
                                                <h4>Suporte Técnico</h4>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="spacer-half"></div>
                                <a class="btn-main" href="https://trycpanel.net/" target="_blank">Demo cPanel</a></a>
                                <a class="btn-main" href="https://webpro-win.demo.plesk.com:8443/smb/web/view" target="_blank">Demo Plesk</a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <section id="section-pricing" class="no-top" data-bgimage='url(images/background/1.jpg) top'>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 offset-lg-3">
                            <div class="text-center">
                                <h5 class="s2">Serviços Disponíveis</h5>
                                <h2>Confira os <span class="id-color">planos ideias</span> para o seu negócio</h2>
                                <div class="spacer-20"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row wow fadeInUp">
                        <div class="col text-center">
                            <div class="switch-set">
                                <div>Mensal</div>
                                <div><input id="sw-1" class="switch" type="checkbox"></div>
                                <div>Anual</div>
                                <div class="spacer-20"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row de_pricing-tables shadow-soft g-0">
                        <div class="col-xl-4 col-lg-6">
                            <div class="de_pricing-table type-2">
                                <div class="d-head">
                                    <h3>Hospedagem de Sites</h3>
                                    <p>Solução ideal para quem está começando com o seu Website.</p>
                                </div>
                                <div class="d-price">
                                    <p>A partir de<s></s></p>
                                    <h4 class="opt-1">R$ 18,00<span>/Mensal</span></h4>
                                    <h4 class="opt-2">R$ 180,00<span>/Anual</span></h4>
                                    <p>Antes <s>R$ 25,00 / Mensal</s></p>
                                </div>
                                <div class="d-action">
                                    <a href="Hospedagem-cPanel" class="btn-main opt-1 w-45">cPanel</a> <a href="Hospedagem-Plesk" class="btn-main opt-1 w-49">Plesk</a>
                                    <a href="Hospedagem-cPanel" class="btn-main opt-2 w-45">cPanel</a> <a href="Hospedagem-Plesk" class="btn-main opt-2 w-49">Plesk</a>
                                    <p>Escolha e clique para conferir os planos disponíveis</p>
                                </div>
                                <div class="d-group">
                                    <h4>Principais recursos</h4>
                                    <ul class="d-list">
                                        <li>1 Website</li>
                                        <li>Espaço 150 GB SSD</li>
                                        <li>Transferência Ilimitada</li>
                                        <li>Construtor de Sites</li>
                                        <li>Suporte Técnico</li>
                                    </ul>
                                </div>
                                <div class="d-group">
                                    <h4>Também inclui</h4>
                                    <ul class="d-list">
                                        <li>5 contas de E-mail</li>
                                        <li>Certificado SSL</li>
                                        <li>Composer</li>
                                        <li>Migração de Sites</li>
                                        <li>5 Sub-Dominios</li>
                                        <li>Instalador de APPS</li>
                                        <li>Backup Diário</li>
                                        <li>E muito mais!</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-6">
                            <div class="de_pricing-table type-2">
                                <div class="d-recommend">Recomendado</div>
                                <div class="d-head">
                                    <h3>Revenda de Hospedagem</h3>
                                    <p>Solução ideal para você iniciar o seu negócio online de hospedagem de sites.
                                </div>
                                <div class="d-price">
                                    <p>A partir de<s></s></p>
                                    <h4 class="opt-1">R$75,00<span>/Mensal</span></h4>
                                    <h4 class="opt-2">R$750,00<span>/Anual</span></h4>
                                    <p>Antes <s>R$115,00/ Mensal</s></p>
                                </div>
                                <div class="d-action">
                                    <a href="Revenda-cPanel" class="btn-main opt-1 w-45">cPanel</a> <a href="Revenda-Plesk" class="btn-main opt-1 w-49">Plesk</a> 
                                    <a href="Revenda-cPanel" class="btn-main opt-2 w-45">cPanel</a> <a href="Revenda-Plesk" class="btn-main opt-2 w-49">Plesk</a>
                                    <p>Escolha e clique para conferir os planos disponíveis</p>
                                </div>
                                <div class="d-group">
                                    <h4>Principais recursos</h4>
                                    <ul class="d-list">
                                        <li>Espaço 150 GB SSD</li>
                                        <li>Domínios Ilimitados</li>
                                        <li>Transferência Ilimitada</li>
                                        <li>LiteSpeed Web Server</li>
                                        <li>Suporte Técnico</li>
                                    </ul>
                                </div>
                                <div class="d-group">
                                    <h4>Também inclui</h4>
                                    <ul class="d-list">
                                        <li>E-mails Ilimitados</li>
                                        <li>SSL Grátis</li>
                                        <li>DNS Próprio</li>
                                        <li>Migração Grátis</li>
                                        <li>Composer</li>
                                        <li>99.9% Server Uptime</li>
                                        <li>WHMCS Incluso</li>
                                        <li>E muito mais!</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-6">
                            <div class="de_pricing-table type-2">
                                <div class="d-head">
                                    <h3>Servidores</h3>
                                    <p>Soluções confiáveis e econômicas para suas necessidades de negócios.</p>
                                </div>
                                <div class="d-price">
                                    <p>A partir de<s></s></p>
                                    <h4 class="opt-1">R$47,00<span>/Mensal</span></h4>
                                    <h4 class="opt-2">R$470,00<span>/Anual</span></h4>
                                    <p>Antes <s>R$63,00 / Mensal</s></p>
                                </div>
                                <div class="d-action">
                                    <a href="#PRODUCTLINK" class="btn-main opt-1 w-45">SSD VPS</a> <a href="#PRODUCTLINK" class="btn-main opt-1 w-49">Dedicado</a> 
                                    <a href="#PRODUCTLINK" class="btn-main opt-2 w-45">SSD VPS</a> <a href="#PRODUCTLINK" class="btn-main opt-2 w-49">Dedicado</a>
                                    <p>Escolha e clique para conferir os planos disponíveis</p>
                                </div>
                                <div class="d-group">
                                    <h4>Principais recursos</h4>
                                    <ul class="d-list">
                                        <li>CPU 2 Core</li>
                                        <li>RAM 4 GB</li>
                                        <li>20 GB PCIe NVMe Storage</li>
                                        <li>Bandwidth 1 Gbit/s 2TB</li>
                                        <li>Datacenter USA</li>
                                    </ul>
                                </div>
                                <div class="d-group">
                                    <h4>Sistemas Disponíveis</h4>
                                    <ul class="d-list">
                                        <li>CentOS</li>
                                        <li>Ubuntu</li>
                                        <li>Alma Linux</li>
                                        <li>Debian</li>
                                        <li>Fedora</li>
                                        <li>Windows Server</li>
                                        <li>99.9% Server Uptime</li>
                                        <li>E muito mais!</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <p class="text-danger text-center"><strong>*Promoção por tempo limitado</strong></p>
                </div>
            </section>


            <section id="section-steps" class="no-top">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 offset-lg-3 text-center">
                            <h5 class="s2">Etapas simples</h5>
                            <h2>Como funciona</h2>
                            <p class="lead">Hospedagem fácil e simplificada: etapas simplificadas para configuração e gerenciamento perfeitos do site.</p>
                            <div class="spacer-20"></div>
                        </div>
                        <div class="col-md-12 wow fadeInUp">
                            <div class="container-timeline">
                                <ul>
                                    <li>
                                        <h4>Selecione o plano</h4>
                                        <p>Selecionando o plano ideal para o sucesso do seu site. Adaptado para atender às suas necessidades específicas.</p>
                                    </li>
                                    <li>
                                        <h4>Escolha o domínio</h4>
                                        <p>Escolha um nome de domínio que reflita a finalidade, o conteúdo do seu site ou a natureza do seu negócio.</p>
                                    </li>
                                    <li>
                                        <h4>Login/Registro</h4>
                                        <p>Dê o primeiro passo para criar seu site e alcançar um público mais amplo registrando-se hoje.</p>
                                    </li>
                                    <li>
                                        <h4>Efetue o pagamento</h4>
                                        <p>Oferecemos uma variedade de métodos de pagamento seguros para tornar seu processo de pagamento conveniente e descomplicado.</p>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section id="section-locations" class="no-top no-bottom" data-bgimage='url(images/background/1.jpg) top'>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 offset-lg-3">
                            <div class="col text-center">
                                <h5 class="s2">Datacenter</h5>
                                <h2>Localização dos nossos servidores</h2>
                                <p class="lead">Alcance global, desempenho local: acelere a velocidade do seu site e a experiência do usuário com servidores estratégicos em todo o mundo.</p>
                                <div class="spacer-20"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12 wow fadeInUp">
                            <div class="p-sm-30 pb-sm-0 mb-sm-0">
                                <div class="de-map-hotspot">

                                    <div class="de-spot wow fadeIn" style="top: 24%; left: 53%">
                                        <span>Finland</span>
                                        <div class="de-circle-1"></div>
                                        <div class="de-circle-2"></div>
                                    </div>
                                    <div class="de-spot wow fadeIn" style="top: 50%; left: 70%">
                                        <span>India</span>
                                        <div class="de-circle-1"></div>
                                        <div class="de-circle-2"></div>
                                    </div>
                                    <div class="de-spot wow fadeIn" style="top: 37%; left: 46.5%">
                                        <span>France</span>
                                        <div class="de-circle-1"></div>
                                        <div class="de-circle-2"></div>
                                    </div>
                                    <div class="de-spot wow fadeIn" style="top: 34%; left: 49%">
                                        <span>Germany</span>
                                        <div class="de-circle-1"></div>
                                        <div class="de-circle-2"></div>
                                    </div>
                                    <div class="de-spot wow fadeIn" style="top: 43%; left: 15%">
                                        <span>USA</span>
                                        <div class="de-circle-1"></div>
                                        <div class="de-circle-2"></div>
                                    </div>
                                    <div class="de-spot wow fadeIn" style="top: 72%; left: 29%">
                                        <span>Brasil</span>
                                        <div class="de-circle-1"></div>
                                        <div class="de-circle-2"></div>
                                    </div>
                                    <img src="images/misc/map.png" class="img-fluid" alt="">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="spacer-double"></div>
                </div>
            </section>
            <section id="section-icons" class="no-top">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-10 offset-lg-1">
                            <div class="row wow fadeInDown">
                                <div class="col-lg-4 col-md-4 text-center">
                                    <i class="icon-alarmclock de-icon mb20"></i>
                                    <h4>Sem tempo perdido</h4>
                                    <p class="d-small">Reduza o tempo de inatividade com nossas soluções de servidores eficientes, garantindo que seu site esteja sempre disponível para os visitantes.</p>
                                </div>
                                <div class="col-lg-4 col-md-4 text-center">
                                    <i class="icon-refresh de-icon mb20"></i>
                                    <h4>Fique on-line</h4>
                                    <p class="d-small">Fique on-line: beneficie-se de serviços de hospedagem confiáveis que mantêm seu site operacional 24 horas por dia.</p>
                                </div>
                                <div class="col-lg-4 col-md-4 text-center">
                                    <i class="icon-cloud de-icon mb20"></i>
                                    <h4>Backup Diário</h4>
                                    <p class="d-small">Garanta a segurança dos dados com backups diários, protegendo as informações do seu site contra perdas inesperadas de dados.</p>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </section>
            <section id="section-banner" class="no-bottom no-top" data-bgcolor="#DBEDF7">
                <div class="container">
                    <div class="row align-items-center g-custom-x">
                        <div class="col-lg-5 d-none d-lg-block d-xl-block  text-center">
                            <img class="relative img-fluid mt-60" src="images/misc/2.png" alt="">
                        </div>

                        <div class="col-lg-7">
                            <div class="p-sm-30 pb-sm-0 mb-sm-0">
                                <div class="spacer-20"></div>
                                <h5>Pare de se preocupar, oferecemos garantia de</h5>
                                <h2><span class="color-gradient">30 dias</span> ou o seu dinheiro de volta</h2>
                                <a class="btn-main" href="Hospedagem-Linux">Assinar Agora</a>
                                <p class="d-small mt20">*O cancelamento deve ser no prazo máximo de 30 dias corridos.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section id="section-faq">
                <div class="container">
                    <div class="row">
                        <div class="col text-center">
                            <h5 class="s2">Você tem</h5>
                            <h2>Alguma Pergunta?</h2>
                            <div class="spacer-20"></div>
                        </div>
                    </div>
                    <div class="row g-custom-x">
                        <div class="col-lg-6 wow fadeInUp">
                            <div class="accordion secondary">
                                <div class="accordion-section">
                                    <div class="accordion-section-title" data-tab="#accordion-1">
                                        Como começo com a minha hospedagem de sites ?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-1">
                                        <p>Para começar com hospedagem de sites:</p>
                                        <ol>
                                            <li>Registre um nome de domínio que reflita sua marca.</li>
                                            <li>Selecione um plano de hospedagem que atenda às necessidades do seu site.</li>
                                            <li>Configure seu domínio com seu provedor de hospedagem.</li>
                                            <li>Desfrute de um serviço confiável de hospedagem na web e gerencie seu site sem esforço.</li>
                                        </ol>
                                    </div>

                                    <div class="accordion-section-title" data-tab="#accordion-2">
                                        Qual a diferença entre cada plano de hospedagem?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-2">
                                        <p>As principais diferenças entre os planos de hospedagem normalmente envolvem a quantidade de recursos do servidor alocados (como CPU, RAM e armazenamento), o nível de suporte técnico fornecido e quaisquer recursos adicionais, como certificados SSL ou contas de e-mail. É importante escolher um plano que corresponda ao volume de tráfego e aos requisitos de desempenho do seu site.</p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-3">
                                        Que tipo de hospedagem de site eu preciso?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-3">
                                        <p>O tipo de hospedagem de sites de que você precisa depende do tamanho do seu site, do volume de tráfego e dos requisitos específicos. A hospedagem compartilhada é adequada para sites de pequeno e médio porte com tráfego moderado. A hospedagem VPS oferece mais recursos e flexibilidade para sites em crescimento. Servidores dedicados oferecem máximo desempenho e controle para sites ou aplicativos de grande escala.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 wow fadeInUp">
                            <div class="accordion secondary">
                                <div class="accordion-section">
                                    <div class="accordion-section-title" data-tab="#accordion-b-4">
                                        Por que preciso de um nome de domínio?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-b-4">
                                        <p>Um nome de domínio é o endereço exclusivo do seu site na Internet (por exemplo, www.seusite.com). Ele permite que os visitantes encontrem e acessem seu site facilmente. Ter um nome de domínio também ajuda a estabelecer a identidade e a credibilidade da sua marca online. É essencial para criar uma presença online profissional e construir a confiança do seu público.</p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-b-5">
                                        Meu site está protegido contra hackers??
                                    </div>
                                    <div class="accordion-section-content" id="accordion-b-5">
                                        <p>Sim, seu site está protegido. Implementamos múltiplas medidas de segurança, incluindo:</p>
                                        <ul>
                                            <li>Imunify360 para proteção abrangente do servidor.</li>
                                            <li>Litespeed Web Application Firewall (WAF) para maior segurança.</li>
                                            <li>Auditorias e monitoramento de segurança regulares para detectar e mitigar vulnerabilidades de forma proativa.</li>
                                        </ul>
                                        <p>Essas medidas garantem que seu site permaneça seguro contra ameaças potenciais e mantenha a integridade dos dados.</p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-b-6">
                                        Como faço backup do meu site?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-b-6">
                                        <p>Fazer backup do seu site é essencial para evitar perda de dados. Veja como fazer:</p>
                                        <ul>
                                            <li><strong>cPanel:</strong> Faça login no cPanel, navegue até a seção Backup e use ferramentas como Backup Wizard ou Backup Manager para criar e gerenciar backups.</li>
                                            <li><strong>Plesk:</strong> Acesse o Plesk, vá para a guia Sites e Domínios, selecione Gerenciador de Backup e siga as instruções para agendar e gerenciar backups dos arquivos e bancos de dados do seu site.</li>
                                        </ul>
                                        <p>Backups regulares garantem que você possa restaurar seu site rapidamente em caso de problemas de servidor, violações de segurança ou perda acidental de dados.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        <!-- content close -->
        <a href="#" id="back-to-top"></a>
        <!-- footer begin -->
        <?php include 'include/footer.php'; ?>
        <!-- footer close -->
    </div>

    <!-- Javascript Files
    ================================================== -->
    <script src="js/plugins.js"></script>
    <script src="js/designesia.js"></script>
    <script>
        jQuery(document).ready(function() {
            $(function() {
                // jquery typed plugin
                $(".typed").typed({
                    stringsElement: $('.typed-strings'),
                    typeSpeed: 100,
                    backDelay: 500,
                    loop: true,
                    contentType: 'html', // or text
                    // defaults to false for infinite loop
                    loopCount: false,
                    callback: function() {
                        null;
                    },
                    resetCallback: function() {
                        newTyped();
                    }
                });
            });
        });
    </script>
</body>

</html>